/*****************************************************************************/
/* File         srchstr.h                                                    */
/*                                                                           */
/* Purpose      Search a string for another                                  */
/*                                                                           */
/*****************************************************************************/
#if !defined(H_SRCHSTR)
#define H_SRCHSTR

/*****************************************************************************/
/* Fields are as follows                                                     */
/*                                                                           */
/* pattern              The text pattern as passed in to srh_compile         */
/*                                                                           */
/* lower_pattern        For case insensitive, this is the lower case copy    */
/*                      of the pattern.  For case sensivitive, this is NULL  */
/*                                                                           */
/* pattern_length       The number of bytes in the pattern                   */
/*                                                                           */
/* delta1               The jump table which determines how far to jump if   */
/*                      the string mismatches on a character.  It is indexed */
/*                      by the character in the text string that failed to   */
/*                      match.                                               */
/*                                                                           */
/* delta2               The jump table which determines how far to jump if   */
/*                      the string has matched several characters, but then  */
/*                      failed to match.  It is indexed by the number of     */
/*                      characters that match.                               */
/*****************************************************************************/
struct srh_prog_struct
{
  byte_t  *pattern;
  byte_t  *lower_pattern;
  size_t   pattern_length;
  size_t  *delta1;
  size_t  *delta2;
};
typedef struct srh_prog_struct srh_prog_t;

#if defined(SHORT_EXTERN_NAMES)
#define srh_compile srhcomp
#define srh_search srhsrch
#define srh_destroy srhdstry
#define srhi_compile srhicomp
#define srhi_search srhisrch
#define srhi_destroy srhidstr
#endif

#if !defined(_NO_PROTO)
int strsrh(char *psearchin, char *psearchfor);
int strsrhi(char *psearchin, char *psearchfor);
srh_prog_t *srh_compile(byte_t *pattern, size_t pat_len);
int srh_search(srh_prog_t *prog, byte_t *text, size_t text_len);
void srh_destroy(srh_prog_t *prog);
srh_prog_t *srhi_compile(byte_t *pattern, size_t pat_len);
int srhi_search(srh_prog_t *prog, byte_t *text, size_t text_len);
void srhi_destroy(srh_prog_t *prog);
#else
int strsrh();
int strsrhi();
srh_prog_t *srh_compile();
int    srh_search();
void   srh_destroy();
srh_prog_t *srhi_compile();
int    srhi_search();
void   srhi_destroy();
#endif
#endif
